import os
import shutil
import zipfile
import datetime

#删除文件夹以及里面的所有文件
def remove_dir(path):
    #print("删除文件夹:" + path)
    #去除首位空格
    path=path.strip()
    #去除尾部\号
    path=path.rstrip("\\")

    isExists=os.path.exists(path)
    if isExists:
        shutil.rmtree(path)
        
#创建文件夹
def create_dir(path):
    #print("创建文件夹")
    #去除首位空格
    path=path.strip()
    #去除尾部\号
    path=path.rstrip("\\")

    isExists=os.path.exists(path)
    if not isExists:
        #print(path)
        os.makedirs(path)

def dfs_get_zip_file(input_path,result):
    files = os.listdir(input_path)
    for file in files:
        if os.path.isdir(input_path+'/'+file):
            dfs_get_zip_file(input_path+'/'+file,result)
        else:
            result.append(input_path+'/'+file)

def compress(input_path,zipname):
    f = zipfile.ZipFile(zipname, 'w', zipfile.ZIP_DEFLATED)
    filelists = []
    dfs_get_zip_file(input_path,filelists)
    for file in filelists:
        print(file)
        f.write(file)
    f.close()
    return zipname



def pack(caliName):
    # 判断路径是否存在
    # 存在     True
    # 不存在   False
    isExists=os.path.exists(caliName)
    if isExists:
        remove_dir(caliName)
    create_dir(caliName)#创建目录

    os.mkdir(caliName+"\\en")
    shutil.copyfile("en\\Common.resources.dll",caliName+"\\en\\Common.resources.dll")  
    os.mkdir(caliName+"\\FontGra")
    shutil.copyfile("FontGra\\FontGraphics.ttf",caliName+"\\FontGra\\FontGraphics.ttf")
    shutil.copyfile("FontGra\\NwControl.ttf",caliName+"\\FontGra\\NwControl.ttf")
    os.mkdir(caliName+"\\ko")
    shutil.copyfile("ko\\Common.resources.dll",caliName+"\\ko\\Common.resources.dll")
    os.mkdir(caliName+"\zh-TW")
    shutil.copyfile("zh-TW\\Common.resources.dll",caliName+"\\zh-TW\\Common.resources.dll")
    
    needCopyFile = ["BTSCali.exe"
    ,"BTSDALib.dll"
    ,"BTSGraph.dll"
    ,"BTSGraph.dll"
    ,"BTSZipSharp.dll"
    ,"Common.dll"
    ,"CommonCtrl.dll"
    ,"CommonCtrlEx.dll"
    ,"CommonMySql.dll"
    ,"Curve.dll"
    ,"DBC.Net.dll"
    ,"Google.ProtocolBuffers.dll"
    ,"ICSharpCode.SharpZipLib.dll"
    ,"itextsharp.dll"
    ,"Log.dll"
    ,"Microsoft.WindowsAPICodePack.dll"
    ,"Microsoft.WindowsAPICodePack.Shell.dll"
    ,"MySql.Data.dll"
    ,"Network.dll"
    ,"NetworkBase.dll"
    ,"Newtonsoft.Json.dll"
    ,"NPOI.dll"
    ,"NPOI.OOXML.dll"
    ,"NPOI.OpenXml4Net.dll"
    ,"NPOI.OpenXmlFormats.dll"
    ,"NwCaliEx.dll"
    ,"NwCaliUI.dll"
    ,"Proto.dll"
    ,"Regedit.dll"
    ,"Secs4Net.dll"
    ,"Step.dll"
    ,"System.Runtime.CompilerServices.Unsafe.dll"
    ,"ThoughtWorks.QRCode.dll"
    ,"7z.dll"
    ,"7z64.dll"
    ,"MSA.dll"
    ,"ZwjList.dll"
    ,"RestSharp.dll"
    ,"NWControl.dll"]

    for x in needCopyFile:
        shutil.copyfile(x,caliName+"\\"+x)
        print("\t"+x)

if __name__ == "__main__":
    strTime=datetime.datetime.now().strftime('%Y%m%d')
    dirName="BTSCali8.0.0_"+strTime
    zipName="BTSCali8.0.0_"+strTime+".zip"
    print("开始打包")
    pack(dirName)
    print("开始压缩")
    compress(dirName,zipName)
    print("压缩完毕 路径："+os.getcwd()+"\\"+zipName)
    remove_dir(dirName)
