# -*- coding: cp936 -*-


'''
Created on 2012-8-12
@author: walfred
@module: loggingmodule.FinalLogger
'''
import os
import sys
import logging.handlers


'''
%(pathname)s Full pathname of the source file where the logging call was issued(if available).

%(filename)s Filename portion of pathname.

%(module)s Module (name portion of filename).

%(funcName)s Name of function containing the logging call.

%(lineno)d Source line number where the logging call was issued (if available).

'''


class DataSerial:
    logger = None
    levels = {"n" : logging.NOTSET,
              "d" : logging.DEBUG,
              "i" : logging.INFO,
              "w" : logging.WARN,
              "e" : logging.ERROR,
              "c" : logging.CRITICAL}
    log_level = "d"
    log_file = None
    log_max_byte = 10 * 1024 * 1024;
    log_backup_count = 5

    def getDataSerial(snamedir):
        if DataSerial.logger is not None:
            return DataSerial.logger
        DataSerial.logger = logging.Logger("oggingmodule.DataSerial")
        DataSerial.log_file = snamedir + "\\dataSerial.txt"
        log_handler = logging.handlers.RotatingFileHandler(filename = DataSerial.log_file,\
                                                           maxBytes = DataSerial.log_max_byte,\
                                                           backupCount = DataSerial.log_backup_count)
        log_fmt = logging.Formatter("%(message)s")
        log_handler.setFormatter(log_fmt)
        DataSerial.logger.addHandler(log_handler)
        DataSerial.logger.setLevel(DataSerial.levels.get(DataSerial.log_level))
        return DataSerial.logger
    
