# -*- coding: cp936 -*-

from ctypes import *

##
class ver1TChannelUnit(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("rowID", c_ubyte), ("colID", c_ubyte), ("index", c_ubyte), ("realChID", c_ubyte)]


class ver1TChTable(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("channelMapTbl", ver1TChannelUnit * 256),
                ("rowMapTbl", c_ubyte * 256 * (1 + 32)),
                ("achBindToMchTbl", c_ushort * 256)]

class ver1TTestIDUnit(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("rowID", c_ubyte), ("colID", c_ubyte), ("nothing", c_ushort), ("testID", c_uint)]

class ver1TestIDTbl(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("mTestIDTbl", ver1TTestIDUnit * 256)]

##################################################################################
class ver2TChlMap(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("rowID", c_ubyte), ("colID", c_ubyte), ("index", c_ubyte)]


class ver2TSyncMap(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("syncNo", c_ushort), ("syncIndex", c_ubyte)]


class ver2TChMapTbl(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("chlMap", ver2TChlMap), ("testID", c_uint), ("syncMap", ver2TSyncMap)]

    
class ver2TMapTbl(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("mapTable", ver2TChMapTbl * 256), ("writeSer", c_uint)]##, ("crc32", c_uint)]

    
