# -*- coding: cp936 -*-

from ctypes import *


## TMsgSaveEngine ver1
class ver1TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("mainChNo", c_ubyte), ("chType", c_ubyte), ("channelNoInfoRow", c_ubyte), ("channelNoInfoCol", c_ubyte), ("channelNoInfoIndex", c_ubyte),
                ("engineState", c_ubyte), ("testId", c_uint),
                ("stepNum", c_ushort), ("stepNo", c_ushort), ("isAlarmClosed", c_ubyte),
                ("dfDataIndex", c_uint), ("platformPointVolRec", c_ubyte * 3),
                ("logIndex", c_uint), ("startDFFlag", c_ubyte), ("sampleStatus", c_ubyte),
                ("detalVolFlag", c_ubyte), ("detalVolZeroPoint", c_int), ("totalTime", c_ulonglong),
                ("phaseInCCCVC", c_ubyte), ("testTime", c_ulonglong), ("lastSampleVol", c_int),
                ("sampleCount", c_uint), ("sampleOmitted", c_ubyte), ("sampleTimeChange", c_ulonglong),
                ("volMax", c_int), ("timeChange", c_ulonglong), ("savedVoltage", c_int),
                ("savedCurrent", c_int), ("chgCap", c_longlong), ("dchgCap", c_longlong),
                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong), ("waitDCRStepFlag", c_ubyte),
                ("mchDCRFlag", c_ubyte), ("achDCRFlag", c_ubyte), ("dcrStartStepFlag", c_ubyte),
                ("dcrEndStepFlag", c_ubyte), ("dcrCutOffFlag", c_ubyte), ("mchDCRk", c_uint),
                ("mchChDFDCR", c_int * 5), ("cycleNum", c_uint), ("cycleStackSize", c_ubyte),
                ("auxChNum", c_ubyte), ("uniteData", c_ubyte * 10), ("latestParaRunTime", c_uint),
                ("latestParaRunNo", c_uint), ("lastErrCode", c_ubyte), ("CCCStepCnt", c_ubyte),
                ("stepSwitchNum", c_uint)]

###ver2  ver1 ȣ("CCCStepCnt", c_ubyte)("stepSwitchNum", c_uint)֮
###("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ͬʱһЩݣver2
    
## TMsgSaveEngine ver2
class ver2TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("mainChNo", c_ubyte), ("chType", c_ubyte), ("channelNoInfoRow", c_ubyte), ("channelNoInfoCol", c_ubyte), ("channelNoInfoIndex", c_ubyte),
                ("engineState", c_ubyte), ("testId", c_uint),
                ("stepNum", c_ushort), ("stepNo", c_ushort), ("isAlarmClosed", c_ubyte),
                ("dfDataIndex", c_uint), ("platformPointVolRec", c_ubyte * 3),
                ("logIndex", c_uint), ("startDFFlag", c_ubyte), ("sampleStatus", c_ubyte),
                ("detalVolFlag", c_ubyte), ("detalVolZeroPoint", c_int), ("totalTime", c_ulonglong),
                ("phaseInCCCVC", c_ubyte), ("testTime", c_ulonglong), ("lastSampleVol", c_int),
                ("sampleCount", c_uint), ("sampleOmitted", c_ubyte), ("sampleTimeChange", c_ulonglong),
                ("volMax", c_int), ("timeChange", c_ulonglong), ("savedVoltage", c_int),
                ("savedCurrent", c_int), ("chgCap", c_longlong), ("dchgCap", c_longlong),
                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong), ("waitDCRStepFlag", c_ubyte),
                ("mchDCRFlag", c_ubyte), ("achDCRFlag", c_ubyte), ("dcrStartStepFlag", c_ubyte),
                ("dcrEndStepFlag", c_ubyte), ("dcrCutOffFlag", c_ubyte), ("mchDCRk", c_uint),
                ("mchChDFDCR", c_int * 5), ("cycleNum", c_uint), ("cycleStackSize", c_ubyte),
                ("auxChNum", c_ubyte), ("uniteData", c_ubyte * 10), ("latestParaRunTime", c_uint),
                ("latestParaRunNo", c_uint), ("lastErrCode", c_ubyte), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int),
                ("globalVariable", c_float * 100)]


## TMsgSaveEngine ֮ѭջ̬仯,TMsgSaveEngineеcycleStackSize
## len = cycleStackSize * (c_ushort + c_uint + c_ushort)


##TAchInfoOfEngineState ̬TMsgSaveEngineе auxChNum ء
## len = sizeof(ver2TAchInfoOfEngineState)
class ver123TAchInfoOfEngineState(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("chNo", c_ubyte), ("chType", c_ubyte), ("chTypeDetail", c_ubyte),
                ("chMap", c_ubyte * 3), ("varAuxIndex", c_uint), ("varAChTimeChange", c_uint),
                ("varSavedAChVoltage", c_int), ("varSavedAChTemperature", c_short),
                ("varTIIIndex", c_uint), ("tiiSample", c_ushort * 4)]
                
##ATL Ϊ sizeof(TATLProtectVar) = 6664 Byte

## mESWriteSer 4Byte ͡CRC32Уֵ

## ver2  ver3 ڣver3ûver2еATLصĲˡatlVolJumpValueLast 4ByteatlLatestCCCCap 8Byte֮⣮







## TMsgSaveEngine ver3  ver2ȶ ah wh
class ver3TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("mainChNo", c_ubyte), ("chType", c_ubyte), ("channelNoInfoRow", c_ubyte), ("channelNoInfoCol", c_ubyte), ("channelNoInfoIndex", c_ubyte),
                ("engineState", c_ubyte), ("testId", c_uint),
                ("stepNum", c_ushort), ("stepNo", c_ushort), ("isAlarmClosed", c_ubyte),
                ("dfDataIndex", c_uint), ("platformPointVolRec", c_ubyte * 3),
                ("logIndex", c_uint), ("startDFFlag", c_ubyte), ("sampleStatus", c_ubyte),
                ("detalVolFlag", c_ubyte), ("detalVolZeroPoint", c_int), ("totalTime", c_ulonglong),
                ("phaseInCCCVC", c_ubyte), ("testTime", c_ulonglong), ("lastSampleVol", c_int),
                ("sampleCount", c_uint), ("sampleOmitted", c_ubyte), ("sampleTimeChange", c_ulonglong),
                ("volMax", c_int), ("timeChange", c_ulonglong), ("savedVoltage", c_int),
                ("savedCurrent", c_int), ("chgCap", c_longlong), ("dchgCap", c_longlong),
                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong), ("waitDCRStepFlag", c_ubyte),
                ("mchDCRFlag", c_ubyte), ("achDCRFlag", c_ubyte), ("dcrStartStepFlag", c_ubyte),
                ("dcrEndStepFlag", c_ubyte), ("dcrCutOffFlag", c_ubyte), ("mchDCRk", c_uint),
                ("mchChDFDCR", c_int * 5), ("cycleNum", c_uint), ("cycleStackSize", c_ubyte),
                ("auxChNum", c_ubyte), ("uniteData", c_ubyte * 10), ("latestParaRunTime", c_uint),
                ("latestParaRunNo", c_uint), ("lastErrCode", c_ubyte), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int), ("ah", c_longlong),
                ("wh", c_longlong), ("globalVariable", c_float * 100)]



## TMsgSaveEngine ver4  ver3ޱ仯,ֻǱʱĸݵĵλ˱仯
class ver4TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("dataVer", c_uint),
                ("mainChNo", c_ubyte), ("chType", c_ubyte), ("channelNoInfoRow", c_ubyte), ("channelNoInfoCol", c_ubyte), ("channelNoInfoIndex", c_ubyte),
                ("engineState", c_ubyte), ("testId", c_uint),
                ("stepNum", c_ushort), ("stepNo", c_ushort), ("isAlarmClosed", c_ubyte),
                ("dfDataIndex", c_uint), ("platformPointVolRec", c_ubyte * 3),
                ("logIndex", c_uint), ("startDFFlag", c_ubyte), ("sampleStatus", c_ubyte),
                ("detalVolFlag", c_ubyte), ("detalVolZeroPoint", c_int), ("totalTime", c_ulonglong),
                ("phaseInCCCVC", c_ubyte), ("testTime", c_ulonglong), ("lastSampleVol", c_int),
                ("sampleCount", c_uint), ("sampleOmitted", c_ubyte), ("sampleTimeChange", c_ulonglong),
                ("volMax", c_int), ("timeChange", c_ulonglong), ("savedVoltage", c_int),
                ("savedCurrent", c_int), ("chgCap", c_longlong), ("dchgCap", c_longlong),
                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong), ("waitDCRStepFlag", c_ubyte),
                ("mchDCRFlag", c_ubyte), ("achDCRFlag", c_ubyte), ("dcrStartStepFlag", c_ubyte),
                ("dcrEndStepFlag", c_ubyte), ("dcrCutOffFlag", c_ubyte), ("mchDCRk", c_uint),
                ("mchChDFDCR", c_int * 5), ("cycleNum", c_uint), ("cycleStackSize", c_ubyte),
                ("auxChNum", c_ubyte), ("uniteData", c_ubyte * 10), ("latestParaRunTime", c_uint),
                ("latestParaRunNo", c_uint), ("lastErrCode", c_ubyte), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int), ("ah", c_longlong),
                ("wh", c_longlong), ("globalVariable", c_float * 100)]


##ver3ver4仯Ϊ:("chgCap", c_longlong), ("dchgCap", c_longlong),
##                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong),
##                ("ah", c_longlong), ("wh", c_longlong)
## λmASΪmAmS,Ҫ*1000.




'''
54TMsgSaveEngine     TBOOL nd96PlcNeedLeakpState;
                                TBOOL nd96PlcIgnoreLeakpState;
                                TBOOL nd96PlcLeakedAir;
'''
class ver5TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("dataVer", c_uint),
                ("mainChNo", c_ubyte), ("chType", c_ubyte), ("channelNoInfoRow", c_ubyte), ("channelNoInfoCol", c_ubyte), ("channelNoInfoIndex", c_ubyte),
                ("engineState", c_ubyte), ("testId", c_uint),
                ("stepNum", c_ushort), ("stepNo", c_ushort), ("isAlarmClosed", c_ubyte),
                ("dfDataIndex", c_uint), ("platformPointVolRec", c_ubyte * 3),
                ("logIndex", c_uint), ("startDFFlag", c_ubyte), ("sampleStatus", c_ubyte),
                ("detalVolFlag", c_ubyte), ("detalVolZeroPoint", c_int), ("totalTime", c_ulonglong),
                ("phaseInCCCVC", c_ubyte), ("testTime", c_ulonglong), ("lastSampleVol", c_int),
                ("sampleCount", c_uint), ("sampleOmitted", c_ubyte), ("sampleTimeChange", c_ulonglong),
                ("volMax", c_int), ("timeChange", c_ulonglong), ("savedVoltage", c_int),
                ("savedCurrent", c_int), ("chgCap", c_longlong), ("dchgCap", c_longlong),
                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong), ("waitDCRStepFlag", c_ubyte),
                ("mchDCRFlag", c_ubyte), ("achDCRFlag", c_ubyte), ("dcrStartStepFlag", c_ubyte),
                ("dcrEndStepFlag", c_ubyte), ("dcrCutOffFlag", c_ubyte), ("mchDCRk", c_uint),
                ("mchChDFDCR", c_int * 5), ("cycleNum", c_uint), ("cycleStackSize", c_ubyte),
                ("auxChNum", c_ubyte), ("uniteData", c_ubyte * 10), ("latestParaRunTime", c_uint),
                ("latestParaRunNo", c_uint), ("lastErrCode", c_ubyte), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int), ("ah", c_longlong),
                ("wh", c_longlong), ("globalVariable", c_float * 100),
                ("nd96PlcNeedLeakpState", c_ubyte), ("nd96PlcIgnoreLeakpState", c_ubyte),
                ("nd96PlcLeakedAir", c_ubyte)]


'''
65ͬ
'''

'''

75 6 nd96PlcLeakedAir ֮

'''


class TPressCtrlPara(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("flag", c_ubyte), ("csvtVacuum", c_uint), ("csvtValveOpenTime", c_uint),
                ("csvtValveCloseTime", c_uint), ("csvtVacuumMethod", c_ubyte), ("csvtVacuumType", c_ubyte)]


class ver7TMsgSaveEnginePre(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("dataVer", c_uint),
                ("mainChNo", c_ubyte), ("chType", c_ubyte), ("channelNoInfoRow", c_ubyte), ("channelNoInfoCol", c_ubyte), ("channelNoInfoIndex", c_ubyte),
                ("engineState", c_ubyte), ("testId", c_uint),
                ("stepNum", c_ushort), ("stepNo", c_ushort), ("isAlarmClosed", c_ubyte),
                ("dfDataIndex", c_uint), ("platformPointVolRec", c_ubyte * 3),
                ("logIndex", c_uint), ("startDFFlag", c_ubyte), ("sampleStatus", c_ubyte),
                ("detalVolFlag", c_ubyte), ("detalVolZeroPoint", c_int), ("totalTime", c_ulonglong),
                ("phaseInCCCVC", c_ubyte), ("testTime", c_ulonglong), ("lastSampleVol", c_int),
                ("sampleCount", c_uint), ("sampleOmitted", c_ubyte), ("sampleTimeChange", c_ulonglong),
                ("volMax", c_int), ("timeChange", c_ulonglong), ("savedVoltage", c_int),
                ("savedCurrent", c_int), ("chgCap", c_longlong), ("dchgCap", c_longlong),
                ("chgEnergy", c_longlong), ("dchgEnergy", c_longlong), ("waitDCRStepFlag", c_ubyte),
                ("mchDCRFlag", c_ubyte), ("achDCRFlag", c_ubyte), ("dcrStartStepFlag", c_ubyte),
                ("dcrEndStepFlag", c_ubyte), ("dcrCutOffFlag", c_ubyte), ("mchDCRk", c_uint),
                ("mchChDFDCR", c_int * 5), ("cycleNum", c_uint), ("cycleStackSize", c_ubyte),
                ("auxChNum", c_ubyte), ("uniteData", c_ubyte * 10), ("latestParaRunTime", c_uint),
                ("latestParaRunNo", c_uint)]


class ver7TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('prev7data', ver7TMsgSaveEnginePre), ("lastErrCode", c_ubyte * 2), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int), ("ah", c_longlong),
                ("wh", c_longlong), ("globalVariable", c_float * 100),
                ("nd96PlcNeedLeakpState", c_ubyte), ("nd96PlcIgnoreLeakpState", c_ubyte),
                ("nd96PlcLeakedAir", c_ubyte),
                ("reserveStopCount", c_uint), ("appointStepCount", c_uint),
                ("tempRunTime", c_uint), ("latestPressCtrlPara", TPressCtrlPara), ("stepType", c_ubyte)]
    



''' ver8ʹõĽṹ '''    

class TReservePause(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('reserveStep', c_ushort), ('reserveCycle', c_uint)]    


class TReservePauseData(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('reservedata', TReservePause), ('reserveType', c_ubyte)]    
    

class TResePauseInfo(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('num', c_ubyte), ('info', TReservePauseData * 5),
                ('overTime', c_uint), ('firstArrive', c_ubyte)]    

class ver8ifloat(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("ifloat", c_float * 24)]
    
#globalVariableҲԭ24,ע
class ver8ChangeStart(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('prev7data', ver7TMsgSaveEnginePre), ("lastErrCode", c_ubyte * 2), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int), ("ah", c_longlong),
                ("wh", c_longlong), ("globalVariable", c_float * 124),
                ("nd96PlcNeedLeakpState", c_ubyte), ("nd96PlcIgnoreLeakpState", c_ubyte),
                ("nd96PlcLeakedAir", c_ubyte)]

class ver8Tail(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [("tempRunTime", c_uint), ("latestPressCtrlPara", TPressCtrlPara), ("stepType", c_ubyte),
                ('usedWXLevel', c_ubyte)]

class ver8TMsgSaveEngine(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('beforeData', ver8ChangeStart), ("resePauseInfo", TResePauseInfo),
                ("v8tail", ver8Tail)]    
    
#ver9б8 globalVariable 149-124=25
class ver9ChangeStart(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('prev7data', ver7TMsgSaveEnginePre), ("lastErrCode", c_ubyte * 2), ("CCCStepCnt", c_ubyte),
                ("ctrlStepStatus", c_ubyte), ("ctrlStepSetVal", c_ubyte), ("stepSwitchNum", c_uint),
                ("volMin", c_int), ("currentMax", c_int), ("currentMin", c_int), ("ah", c_longlong),
                ("wh", c_longlong), ("globalVariable", c_float * 124)]
    
#ver9 whole
class ver9whole(LittleEndianStructure):
    _pack_ = 1
    _fields_ = [('first', ver9ChangeStart), ('second', c_float * 25), ("nd96PlcNeedLeakpState", c_ubyte),
                ("nd96PlcIgnoreLeakpState", c_ubyte), ("nd96PlcLeakedAir", c_ubyte),
                ("resePauseInfo", TResePauseInfo), ("v8tail", ver8Tail)]

    
#910ͬ
    

    


