#!/usr/bin/env python
# -*- coding: cp936 -*-

import struct
import BaseProc
import os
import logging
import logger

logp = logger.FinalLogger.getLogger()

class ver9To10(BaseProc.BaseProc):
    def __init__(self):
        BaseProc.BaseProc.__init__(self, 9, 10)

    def process(self, inFn):
        logp.debug ('%d to %d', self.old, self.new)
        fd = open(inFn, 'rb')
        data = fd.read()
        fd.close()
        if (self.old == struct.unpack("<I",data[0:4])[0]):
            os.rename(inFn, inFn + '.pre' + str(self.old))
            fd = open(inFn, 'wb')
            newVer = struct.pack("<I", self.new)
            fd.write(newVer)
            fd.write(data[4:])
            fd.close()
            return 0
        else:
            logp.error ('old ver in file not equal to' + self.old)
            return 1
