# -*- coding: cp936 -*-


'''
Created on 2012-8-12
@author: walfred
@module: loggingmodule.FinalLogger
'''
import os
import sys
import logging.handlers


'''
%(pathname)s Full pathname of the source file where the logging call was issued(if available).

%(filename)s Filename portion of pathname.

%(module)s Module (name portion of filename).

%(funcName)s Name of function containing the logging call.

%(lineno)d Source line number where the logging call was issued (if available).

'''


class FinalLogger:
    logger = None
    levels = {"n" : logging.NOTSET,
              "d" : logging.DEBUG,
              "i" : logging.INFO,
              "w" : logging.WARN,
              "e" : logging.ERROR,
              "c" : logging.CRITICAL}
    log_level = "d"
    log_file = os.path.dirname(sys.argv[0]) + '\\updatazwjscript.log'
    log_max_byte = 10 * 1024 * 1024;
    log_backup_count = 5

    def getLogger():
        if FinalLogger.logger is not None:
            return FinalLogger.logger
        FinalLogger.logger = logging.Logger("oggingmodule.FinalLogger")
        log_handler = logging.handlers.RotatingFileHandler(filename = FinalLogger.log_file,\
                                                           maxBytes = FinalLogger.log_max_byte,\
                                                           backupCount = FinalLogger.log_backup_count)
        log_fmt = logging.Formatter("[%(asctime)s] [%(filename)s] [%(lineno)d] [%(levelname)s] %(message)s")
        log_handler.setFormatter(log_fmt)
        FinalLogger.logger.addHandler(log_handler)
        FinalLogger.logger.setLevel(FinalLogger.levels.get(FinalLogger.log_level))
        return FinalLogger.logger
    
